import math

moistureRamps = [
    [-0.8, 0x800000],
    [-0.24, 0xFF0000],
    [-0.032, 0xFFFF00],
    [0.032, 0x00FFFF],
    [0.24, 0x0000FF],
    [0.8, 0x000080],
]


def haversine(lat1, lon1, lat2, lon2):
    R = 6371000  # radius of Earth in meters
    phi1 = math.radians(lat1)
    phi2 = math.radians(lat2)
    delta_phi = math.radians(lat2 - lat1)
    delta_lambda = math.radians(lon2 - lon1)

    a = math.sin(delta_phi / 2) ** 2 + \
        math.cos(phi1) * math.cos(phi2) * math.sin(delta_lambda / 2) ** 2
    c = 2 * math.atan2(math.sqrt(a), math.sqrt(1 - a))

    return R * c  # returns distance in meters


def calculate_ha(zone: list[tuple[float, float]]):
    area = 0
    for i in range(len(zone)):
        xi, yi = zone[i]
        next_index = (i + 1) % len(zone)
        xj, yj = zone[next_index]
        area += xi * yj - xj * yi
    area_square_meters = (
        abs(area) / 2 * 111320 * 111320 * math.cos(zone[0][0] * math.pi / 180)
    )
    area_ha = area_square_meters / 10000
    return area_ha


def get_lat_long(coords: str):
    ret_value = []
    coords = coords.split(" ")
    for coord in coords:
        lat, long = coord.split(",")
        ret_value.append((float(lat), float(long)))

    return ret_value


def ramp(value, ramps=moistureRamps):
    for i in range(1, len(ramps)):
        if value <= ramps[i][0]:
            break
    i -= 1
    r1, g1, b1 = ramps[i][1] >> 16, (ramps[i][1] >> 8) & 0xFF, ramps[i][1] & 0xFF
    r2, g2, b2 = (
        ramps[i + 1][1] >> 16,
        (ramps[i + 1][1] >> 8) & 0xFF,
        ramps[i + 1][1] & 0xFF,
    )
    ratio = (value - ramps[i][0]) / (ramps[i + 1][0] - ramps[i][0])
    r = int(r1 + (r2 - r1) * ratio)
    g = int(g1 + (g2 - g1) * ratio)
    b = int(b1 + (b2 - b1) * ratio)
    return r, g, b


def latlng_to_pixel(
    lat, lng, min_lat, max_lat, min_lng, max_lng, image_width, image_height
):
    x = (lng - min_lng) / (max_lng - min_lng) * image_width
    y = (max_lat - lat) / (max_lat - min_lat) * image_height
    return int(x), int(y)
