from fastapi import Depends, HTTPException, status
from sqlalchemy.orm import Session

from app.config.call_session import CallSession
from app.database.repos.user_repo import UserRepo
from app.database.sql.models import RoleEnum, UserProjectRole

def check_if_user_is_super_user(
    user_id_crm: str, 
    session: CallSession,
) -> None:
    is_super_user = session[UserRepo].is_super_user(user_id_crm)
    if not is_super_user:
        raise HTTPException(
            status_code=status.HTTP_403_FORBIDDEN,
            detail="You do not have permission to perform this action.",
        )
    
def check_if_user_is_super_user_or_project_owner(
    user_id_crm: str, 
    project_id: int,
    session: CallSession,
) -> None:
    is_super_user = session[UserRepo].is_super_user(user_id_crm)
    if is_super_user:
        return

    user_project_role = session[UserRepo].get_user_project_role(user_id_crm, project_id)    

    if not user_project_role or user_project_role.role != RoleEnum.project_owner:
        raise HTTPException(
            status_code=status.HTTP_403_FORBIDDEN,
            detail="You do not have permission to perform this action.",
        )
    
def check_if_user_is_super_user_or_project_owner_or_project_partner(
        user_id_crm: str,
        project_id: int,
        session: CallSession,
) -> None:
    is_super_user = session[UserRepo].is_super_user(user_id_crm)
    if is_super_user:
        return

    user_project_role = session[UserRepo].get_user_project_role(user_id_crm, project_id)

    if not user_project_role or user_project_role.role not in (RoleEnum.project_owner, RoleEnum.project_partner):
        raise HTTPException(
            status_code=status.HTTP_403_FORBIDDEN,
            detail="You do not have permission to perform this action.",
        )