# import os
import smtplib
from email.message import EmailMessage
from email.utils import make_msgid, formataddr
# from pathlib import Path

from app.config import email_settings


def send_email(to_email: str, subject: str, content: str):
    msg = EmailMessage()
    msg["Subject"] = subject
    msg["From"] = formataddr(
        ("Monitor Planteaza in Romania", email_settings.EMAIL_ADDRESS)
    )
    msg["To"] = to_email
    msg["Message-ID"] = make_msgid()
    msg.set_content(content)

    # template_path = (
    #     Path(os.path.abspath(__file__)).parent / "templates" / "email_verification"
    # )
    # with open(template_path / "page.html", encoding="utf-8") as file:
    #     html_content = file.read()

    # Replace link placeholder with reset link
    # html_content = html_content.replace(
    #     "{{FRONTEND_URL_EMAIL_CONFIRMATION}}",
    #     f"{email_settings.FRONTEND_URL}/email_confirmation?token={token}",
    # )

    # msg.add_alternative(html_content, subtype="html")

    with smtplib.SMTP_SSL(
        email_settings.SMTP_SERVER, email_settings.SMTP_PORT
    ) as server:
        server.login(email_settings.EMAIL_ADDRESS, email_settings.EMAIL_PASSWORD)
        server.send_message(msg)
        server.quit()
