from sqlalchemy import Column, ForeignKey, Integer, String, DateTime, Boolean, Float
from sqlalchemy.orm import declarative_base
from sqlalchemy import Enum as SqlEnum
from sqlalchemy.orm import relationship
from enum import Enum
Base = declarative_base()


class ProjectDb(Base):
    __tablename__ = "projects"

    project_id = Column(Integer, primary_key=True, index=True)
    project_name = Column(String(300))
    partner_id = Column(Integer)
    partner_name = Column(String(200))
    country_id = Column(Integer)
    country_name = Column(String(200))
    county_id = Column(Integer, nullable=True)
    county_name = Column(String(200), nullable=True)
    city_id = Column(Integer, nullable=True)
    city_name = Column(String(200), nullable=True)
    warning_moisture_level = Column(String(100), default="30.0")
    critical_moisture_level = Column(String(100), default="23.0")
    soil_type = Column(String(100))
    type = Column(String(100))
    co2 = Column(String(100))
    social_goal = Column(String(100))
    created_at = Column(DateTime)
    updated_at = Column(DateTime)
    deleted = Column(Integer)
    deleted_at = Column(DateTime)


class ProjectCoordonatesDb(Base):
    __tablename__ = "project_coordonates"

    coordonate_id = Column(Integer, primary_key=True, index=True)
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)
    coordonates = Column(String(4000))
    deleted = Column(Integer)
    deleted_at = Column(DateTime)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)


class FileDb(Base):
    __tablename__ = "files"

    file_id = Column(Integer, primary_key=True, index=True)
    file = Column(String(300))
    tag = Column(String(100))
    project_id = Column(
        Integer, ForeignKey("projects.project_id"), index=True, nullable=True
    )
    action_id = Column(
        Integer, ForeignKey("actions.action_id"), index=True, nullable=True
    )
    audit_action_id = Column(
        Integer, ForeignKey("audit_actions.audit_action_id"), index=True, nullable=True
    )


class ProjectZoneDb(Base):
    __tablename__ = "project_zones"

    zone_id = Column(Integer, primary_key=True, index=True)
    partner_id = Column(Integer)
    partner_name = Column(String(200))
    co2 = Column(String(100))
    model = Column(String(100))
    field_schema = Column(String(100))
    zone_coordonates = Column(String(2000))
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)
    project_zone_id = Column(Integer)
    deleted = Column(Integer)
    deleted_at = Column(DateTime)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)


class TreeHoleDetectionDb(Base):
    __tablename__ = "tree_hole_detection"

    tree_hole_detection_id = Column(Integer, primary_key=True, index=True)
    image_filename = Column(String(300))
    csv_filename = Column(String(300))
    tree_number = Column(Integer)
    tree_hole_number = Column(Integer)
    description = Column(String(2000))
    date = Column(DateTime)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)
    deleted_at = Column(DateTime)
    deleted = Column(Integer)
    co2 = Column(Float, nullable=True)
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)


class SpeciesDb(Base):
    __tablename__ = "species"

    species_id = Column(Integer, primary_key=True, index=True)
    species_name = Column(String(200))
    species_slug = Column(String(100))
    sapling_number = Column(Integer)
    project_zone_id = Column(
        Integer, ForeignKey("project_zones.zone_id"), index=True, nullable=True
    )
    action_id = Column(
        Integer, ForeignKey("actions.action_id"), index=True, nullable=True
    )


class ActionDb(Base):
    __tablename__ = "actions"

    action_id = Column(Integer, primary_key=True, index=True)
    date = Column(DateTime)
    sapling_number = Column(Integer)
    video_link = Column(String(300), nullable=True)
    deleted = Column(Integer)
    deleted_at = Column(DateTime)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)

    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)


class ActionZoneMTM(Base):
    __tablename__ = "action_zone_mtm"

    action_id = Column(
        Integer, ForeignKey("actions.action_id"), primary_key=True, index=True
    )
    zone_id = Column(
        Integer, ForeignKey("project_zones.zone_id"), primary_key=True, index=True
    )


class ActionTypeDb(Base):
    __tablename__ = "action_types"

    action_type_id = Column(Integer, primary_key=True, index=True)
    slug = Column(String(200))
    name = Column(String(200))
    action_id = Column(
        Integer, ForeignKey("actions.action_id"), index=True, nullable=True
    )
    audit_action_id = Column(
        Integer, ForeignKey("audit_actions.audit_action_id"), index=True, nullable=True
    )


class AuditActionDb(Base):
    __tablename__ = "audit_actions"

    audit_action_id = Column(Integer, primary_key=True, index=True)
    date = Column(DateTime)
    sapling_survival_rate = Column(Integer, nullable=True)
    amount_of_co2_sequestered = Column(Integer, nullable=True)
    type = Column(String(200), nullable=True)
    propose_date = Column(DateTime, nullable=True)
    asap = Column(Boolean, nullable=True)
    biodiversity_notes = Column(String(2000), nullable=True)
    auditor_name = Column(String(200), nullable=True)
    deleted = Column(Integer)
    deleted_at = Column(DateTime)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)

    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)


class AffectedZoneDb(Base):
    __tablename__ = "affected_zones"

    affected_zone_id = Column(Integer, primary_key=True, index=True)
    zone_id = Column(Integer, ForeignKey("project_zones.zone_id"), index=True)
    zone_name = Column(String(200))
    percentage = Column(Integer)
    audit_action_id = Column(
        Integer, ForeignKey("audit_actions.audit_action_id"), index=True
    )


class HumidityDb(Base):
    __tablename__ = "humidity"

    humidity_id = Column(Integer, primary_key=True, index=True)
    humidity = Column(String(100))
    date = Column(DateTime)
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)


class SpeciesInfoDb(Base):
    __tablename__ = "species_info"

    id = Column(Integer, primary_key=True, index=True)
    key = Column(String(200), unique=True)
    name = Column(String(100))
    year1 = Column(Integer, default=0)
    year2 = Column(Integer, default=0)
    year3 = Column(Integer, default=0)
    year4 = Column(Integer, default=0)
    year5 = Column(Integer, default=0)
    year6 = Column(Integer, default=0)
    year7 = Column(Integer, default=0)
    year8 = Column(Integer, default=0)
    year9 = Column(Integer, default=0)
    year10 = Column(Integer, default=0)
    ndvi_index = Column(Float, default=0.0)


class TreeDb(Base):
    __tablename__ = "trees"

    tree_id = Column(Integer, primary_key=True, index=True)
    species_name = Column(String(200), nullable=True)
    species_slug = Column(String(100), nullable=True)
    latitude = Column(String(100), nullable=True)
    longitude = Column(String(100), nullable=True)
    height = Column(String(100), nullable=True)
    diameter = Column(String(100), nullable=True)
    crown_area = Column(Float, nullable=True)         
    co2_year_kg = Column(Float, nullable=True)        
    age = Column(String(100), nullable=True)
    tree_type = Column(String(100), nullable=True)
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)
    partner_id = Column(Integer, nullable=True)
    partner_name = Column(String(200), nullable=True)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)
    deleted_at = Column(DateTime)
    deleted = Column(Integer)


class ProjectPartnerDb(Base):
    __tablename__ = "project_partners"
    project_partner_id = Column(Integer, primary_key=True, index=True)
    project_id = Column(Integer, ForeignKey("projects.project_id"), index=True)
    partner_id = Column(Integer, nullable=False)
    created_at = Column(DateTime)
    updated_at = Column(DateTime)
    deleted_at = Column(DateTime)
    deleted = Column(Integer)


class RoleEnum(str, Enum):
    super_user = "super-user"
    project_owner = "project-owner"
    project_partner = "project-partner"


class User(Base):
    __tablename__ = "users"
    id = Column(Integer, primary_key=True, index=True)
    email = Column(String, unique=True, index=True)
    user_id_crm = Column(String, unique=True, index=True, nullable=True)


class UserProjectRole(Base):
    __tablename__ = "user_project_roles"

    id = Column(Integer, primary_key=True)
    user_id = Column(Integer, ForeignKey("users.id"))
    project_id = Column(Integer, ForeignKey("projects.project_id"), nullable=True)
    role = Column(SqlEnum(RoleEnum), nullable=False)
