from app.database.repos.base_repo import SqlRepo
from app.database.sql.models import TreeDb


class TreeRepo(SqlRepo):

    def get_all_by_project(self, project_id: int):
        return self._sql_session.query(TreeDb).filter(
            TreeDb.project_id == project_id,
            TreeDb.deleted == 0
        ).all()
    
    def get_all_not_assigned_by_project(self, project_id: int):
        return self._sql_session.query(TreeDb).filter(
            TreeDb.project_id == project_id,
            TreeDb.deleted == 0,
            TreeDb.partner_id.is_(None),
        ).all()

    def get_by_id(self, tree_id: int):
        return self._sql_session.query(TreeDb).get(tree_id)

    def add(self, tree: TreeDb):
        self._sql_session.add(tree)

    def commit(self):
        self._sql_session.commit()