from abc import ABC

from sqlalchemy.orm import Session

from app.config.call_session import CallSession


class BaseRepo(ABC):
    pass


class SqlRepo(BaseRepo):
    def __init__(self, app_session: CallSession):
        self._call_session: CallSession = app_session
        self._sql_session: Session = app_session.sql_session

    @property
    def session(self) -> CallSession:
        return self._call_session

    @property
    def connection(self) -> Session:
        return self._sql_session
