from datetime import datetime
from app.controller.schema.action_shema import ActionTypeAddModel
from app.controller.schema.audit_action_shema import AuditActionAddModel
from app.database.repos.base_repo import SqlRepo
from app.database.sql.models import ActionTypeDb, AffectedZoneDb, AuditActionDb


class AuditActionRepo(SqlRepo):
    def __init__(self, app_session):
        super().__init__(app_session)

    def add(
        self, project_id: int, audit_action_model: AuditActionAddModel
    ) -> AuditActionDb:
        audit_action_db = AuditActionDb(
            date=audit_action_model.date,
            type=audit_action_model.action_type,
            sapling_survival_rate=audit_action_model.sapling_survival_rate,
            amount_of_co2_sequestered=audit_action_model.amount_of_co2,
            propose_date=audit_action_model.propose_date,
            asap=audit_action_model.asap,
            biodiversity_notes=audit_action_model.biodiversity_notes,
            auditor_name=audit_action_model.auditor_name,
            project_id=project_id,
            deleted=0,
            deleted_at=datetime.now(),
            created_at=datetime.now(),
            updated_at=datetime.now(),
        )
        self._sql_session.add(audit_action_db)
        self._sql_session.commit()
        self._sql_session.refresh(audit_action_db)
        return audit_action_db

    def get_all(self) -> list[AuditActionDb]:
        return self._sql_session.query(AuditActionDb).all()

    def add_action_type(
        self, audit_action_id: int, action_type_model: ActionTypeAddModel
    ) -> ActionTypeDb:
        action_type_db = ActionTypeDb(
            slug=action_type_model.slug,
            name=action_type_model.name,
            audit_action_id=audit_action_id,
        )
        self._sql_session.add(action_type_db)
        self._sql_session.commit()
        self._sql_session.refresh(action_type_db)

        return action_type_db

    def add_affected_zone(
        self, audit_action_id: int, zone_id: int, zone_name: str, percentage: int
    ):
        affected_zone_db = AffectedZoneDb(
            audit_action_id=audit_action_id,
            zone_id=zone_id,
            zone_name=zone_name,
            percentage=percentage,
        )
        self._sql_session.add(affected_zone_db)
        self._sql_session.commit()
        self._sql_session.refresh(affected_zone_db)

        return affected_zone_db

    def get_by_project_id(self, project_id: int):
        return (
            self._sql_session.query(AuditActionDb)
            .filter_by(project_id=project_id, deleted=0)
            .all()
        )

    def get_action_types_by_audit_action_id(self, audit_action_id: int):
        return (
            self._sql_session.query(ActionTypeDb)
            .filter_by(audit_action_id=audit_action_id)
            .all()
        )

    def get_affected_zones_by_audit_action_id(self, audit_action_id: int):
        return (
            self._sql_session.query(AffectedZoneDb)
            .filter_by(audit_action_id=audit_action_id)
            .all()
        )
