from app.controller.schema import Model


class SpeciesAddModel(Model):
    species_name: str
    species_slug: str
    sapling_number: int


class SpeciesReturnModel(Model):
    species_id: int
    species_name: str
    species_slug: str
    sapling_number: int


class ProjectZoneAddModel(Model):
    partner_id: int
    partner_name: str
    co2: str
    model: str
    field_schema: str
    zone_coordonates: str
    species: list[SpeciesAddModel]


class ProjectZoneUpdateModel(Model):
    co2: str
    model: str
    field_schema: str
    zone_coordonates: str
    species: list[SpeciesAddModel]


class ProjectZoneReturnModel(Model):
    zone_id: int
    project_zone_id: int
    partner_id: int
    partner_name: str
    co2: str
    model: str
    field_schema: str
    zone_coordonates: str
    species: list[SpeciesReturnModel]
    number_of_actions: int = 0
