from typing import Optional
from app.controller.schema import Model


class UserLoginModel(Model):
    """
    Schema for user login.
    """
    email: str
    password: str

class UserResponseModel(Model):
    """
    Schema for user response.
    """
    id: int
    email: str
    user_id_crm: str
    cover: Optional[str] = None
    name: Optional[str] = None
    bearer: Optional[str] = None