from datetime import datetime
from app.controller.schema import Model


class TreeHoleDetectionAdd(Model):
    image_filename: str
    csv_filename: str
    tree_number: int
    tree_hole_number: int
    description: str
    date: str
    created_at: str
    updated_at: str
    deleted_at: str
    deleted: int
    project_id: int
    co2: float | None = None


class TreeHoleDetectionReturn(Model):
    id: int
    image_filename: str
    csv_filename: str
    tree_number: int
    tree_hole_number: int
    description: str
    date: str
    created_at: str
    updated_at: str
    deleted_at: str
    deleted: int
    project_id: int
    co2: float | None = None


class TreeResponse(Model):
    tree_id: int
    species_name: str | None = None
    species_slug: str | None = None
    latitude: str | None = None
    longitude: str | None = None
    height: str | None = None
    diameter: str | None = None
    age: str | None = None
    tree_type: str | None = None
    project_id: int
    partner_id: int | None = None
    partner_name: str | None = None
    created_at: datetime
    updated_at: datetime
    deleted_at: datetime | None = None
    crown_area: float | None = None
    co2_year_kg: float | None = None
