from typing import Optional

from app.controller.schema.action_shema import ActionResponseModel
from app.controller.schema.audit_action_shema import AuditActionResponseModel
from app.controller.schema.file_shema import FileAddModel
from app.controller.schema.zone_shema import ProjectZoneReturnModel
from . import Model


class ProjectAddModel(Model):
    partner_id: int
    partner_name: str
    country_id: int
    country_name: str
    county_id: Optional[int] = None
    county_name: Optional[str] = None
    city_id: Optional[int] = None
    city_name: Optional[str] = None
    warning_moisture_level: Optional[str] = None
    critical_moisture_level: Optional[str] = None
    soil_type: str
    type: str
    co2: str
    social_goal: str
    pedo_report: Optional[FileAddModel] = None
    area_coords: Optional[FileAddModel] = None
    legal_docs: Optional[list[FileAddModel]] = None
    area_coordonates: Optional[list[str]] = None


class HumidityReturnModel(Model):
    humidity_id: int
    humidity: str
    project_id: int
    date: str


class ProjectResponseModel(Model):
    project_id: int
    project_name: str
    partner_name: str
    partner_id: int
    country_id: int
    country_name: str
    county_id: Optional[int] = None
    county_name: Optional[str] = None
    city_id: Optional[int] = None
    city_name: Optional[str] = None
    warning_moisture_level: str
    critical_moisture_level: str
    soil_type: str
    type: str
    co2: str
    social_goal: str
    pedo_report: Optional[str]
    area_coords: Optional[str]
    legal_docs: Optional[list[FileAddModel]]
    area_coordonates: Optional[list[str]] = None
    created_at: str
    updated_at: str
    zones: Optional[list[ProjectZoneReturnModel]] = None
    actions: Optional[list[ActionResponseModel]] = None
    audit_actions: Optional[list[AuditActionResponseModel]] = None
    humidities: Optional[list[HumidityReturnModel]] = None
