from datetime import datetime
from typing import Optional
from app.controller.schema import Model
from app.controller.schema.action_shema import ActionTypeAddModel
from app.controller.schema.file_shema import FileAddModel


class AffectedZoneAddModel(Model):
    percentage: int
    zone_id: int
    zone_name: str


class AuditActionAddModel(Model):
    action_type: Optional[str] = "auditare"
    affected_zones: list[AffectedZoneAddModel]
    amount_of_co2: Optional[int] = None
    asap: Optional[bool] = None
    auditor_name: Optional[str] = None
    biodiversity_images_urls: list[FileAddModel]
    propose_date: Optional[datetime] = None
    biodiversity_notes: Optional[str] = None
    corrective_actions: list[ActionTypeAddModel]
    date: datetime
    images: list[FileAddModel]
    sapling_survival_rate: Optional[int] = None
    volumes_file: Optional[FileAddModel] = None


class AuditActionResponseModel(Model):
    action_id: int
    type: str
    affected_zones: list[AffectedZoneAddModel]
    amount_of_co2_sequestered: Optional[int] = None
    asap: Optional[bool] = None
    auditor_name: Optional[str] = None
    biodiversity_images_urls: list[FileAddModel]
    propose_date: Optional[datetime] = None
    biodiversity_notes: Optional[str] = None
    corrective_actions: list[ActionTypeAddModel]
    date: str
    images: list[FileAddModel]
    sapling_survival_rate: Optional[int] = None
    volumes_file: Optional[FileAddModel] = None
    created_at: str
    updated_at: str
    deleted: int
    deleted_at: str
