from datetime import datetime
from typing import Optional

from app.controller.schema import Model
from app.controller.schema.file_shema import FileAddModel


class ActionTypeAddModel(Model):
    name: str
    slug: str


class ActionSpeciesAddModel(Model):
    id: str
    name: str
    number: int


class ActionSpeciesResponseModel(Model):
    species_slug: str
    species_name: str
    sapling_number: int


class ActionAddModel(Model):
    date: datetime
    sapling_number: Optional[int] = None
    video_link: Optional[str] = None
    action_type: list[ActionTypeAddModel]
    images: list[FileAddModel]
    zones: list[int]
    species: list[ActionSpeciesAddModel]


class ActionResponseModel(Model):
    action_id: int
    date: str
    sapling_number: int
    video_link: Optional[str] = None
    action_type: list[ActionTypeAddModel]
    images: list[FileAddModel]
    zones: list[int]
    species: list[ActionSpeciesResponseModel]
    created_at: str
    updated_at: str
    deleted: int
    deleted_at: str
