from fastapi import APIRouter, Depends

from app.controller.schema.user_schema import UserResponseModel
from app.services.routes import user_service


user_router = APIRouter(
    prefix="/user",
    tags=["user"]
)

@user_router.post(
    "/login",
    summary="Login user",
    response_model=UserResponseModel,
    tags=["user"]
)
def login_user(
    response: UserResponseModel = Depends(user_service.login_user),
) -> UserResponseModel:
    """
    Login user and return user details.
    """
    return response


# list of users
@user_router.get(
    "/list",
    summary="List users",
    response_model=list[UserResponseModel],
    tags=["user"]
)
def list_users(
    response: list[UserResponseModel] = Depends(user_service.list_users),
) -> list[UserResponseModel]:
    """
    List all users.
    """
    return response