from fastapi import APIRouter, Depends, HTTPException, status
from sqlalchemy.orm import Session
from app.config.call_session import CallSession
from app.database.repos.user_repo import UserRepo
from app.database.sql.models import RoleEnum, UserProjectRole
from app.services.utils.user_access import check_if_user_is_super_user

admin_router = APIRouter(prefix="/admin", tags=["Admin"])


@admin_router.get("/users")
def list_users(session: CallSession):
    """List all users with their roles."""
    users = session[UserRepo].get_all_users_with_roles()
    return users


@admin_router.post("/set-role")
def set_user_role(
    user_id: int,
    role: RoleEnum,
    project_id: int | None = None,
    session: CallSession = Depends(),
):
    user_id_crm = session.user_id
    check_if_user_is_super_user(
        user_id_crm, project_id, session
    )
    
    repo = session[UserRepo]
    
    if role == RoleEnum.super_user:
        repo.set_super_user(user_id)
    else:
        repo.set_user_project_role(user_id, project_id, role)
    
    return {"message": f"Role '{role}' assigned successfully to user {user_id}."}
