from pydantic import Field
from pydantic_settings import BaseSettings, SettingsConfigDict


class EnvSettings(BaseSettings):
    model_config = SettingsConfigDict(
        env_file=".env.dev",
        env_file_encoding="utf-8",
        case_sensitive=True,
        extra="ignore",
    )


class AuthSettings(EnvSettings):
    SECRET_KEY: str = Field(alias="AUTH_HANDLE_SECRET_KEY", default="secret")
    AUTH_TOKEN_EXPIRE_DAYS: int = Field(alias="AUTH_TOKEN_EXPIRE_DAYS", default=7)
    RESET_PASSWORD_TOKEN_EXPIRE_MINUTES: int = Field(
        alias="RESET_PASSWORD_TOKEN_EXPIRE_MINUTES", default=15
    )
    SENTINEL_CLIENT_ID: str = Field(alias="SENTINEL_CLIENT_ID")
    SENTINEL_CLIENT_SECRET: str = Field(alias="SENTINEL_CLIENT_SECRET")


class SqlDatabaseSettings(EnvSettings):
    CONNECTION_URL: str = Field(alias="SQL_DATABASE_URL")


class EmailSettings(EnvSettings):
    SMTP_SERVER: str = Field(alias="SMTP_SERVER")
    SMTP_PORT: int = Field(alias="SMTP_PORT")
    EMAIL_ADDRESS: str = Field(alias="EMAIL_ADDRESS")
    EMAIL_PASSWORD: str = Field(alias="EMAIL_PASSWORD")
