import os
from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware
from fastapi.staticfiles import StaticFiles

from app.controller.routes.project_controller import project_router
from app.controller.routes.user_controller import user_router
from app.database.sql import sqlDBManager
from app.controller.routes.admin_controller import admin_router
server = FastAPI(title="Carbon Footprint API", version="0.1.0", root_path="/api")

# ----------- set all CORS enabled origins -----------
origins = ["*"]

server.add_middleware(
    CORSMiddleware,
    allow_origins=origins,
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

# ----------- include all routers -----------
server.include_router(router=project_router)
server.include_router(router=user_router)
server.include_router(router=admin_router)

# ----------- include static files -----------
data_folder = os.path.join(os.path.dirname(__file__), "..", "data")

data_folder = os.path.abspath(data_folder)

if os.path.exists(data_folder):
    server.mount("/data", StaticFiles(directory=data_folder), name="data")
else:
    raise RuntimeError(f"Folderul 'data' nu există în calea: {data_folder}")


# ------------ server startup event ------------
@server.on_event("startup")
async def startup_event():
    sqlDBManager.init()


@server.on_event("shutdown")
async def shutdown_event():
    sqlDBManager.close()
